export function CtaSection() {
  return (
    <section
      id="cta"
      className="border-y border-border bg-background py-12"
    >
      <div className="mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        <div className="grid gap-6 rounded-3xl border border-border bg-white p-5 shadow-[0_20px_70px_rgba(15,23,42,0.08)] sm:grid-cols-[1.3fr_1fr] sm:p-7">
          <div className="space-y-3">
            <h2 className="text-xl font-semibold text-foreground sm:text-2xl">
              آماده‌اید استعلام‌هایتان را به کمبِر بسپارید؟
            </h2>
            <p className="text-sm text-muted-foreground">
              فرم کوتاه ثبت اطلاعات مغازه را پر کنید تا تیم کمبِر برای فعال‌سازی
              حساب و راه‌اندازی اولیه با شما تماس بگیرد.
            </p>
            <ul className="mt-3 grid gap-2 text-[11px] text-muted-foreground sm:grid-cols-2">
              <li className="flex items-center gap-2">
                <span className="h-1.5 w-1.5 rounded-full bg-black" />
                راه‌اندازی بدون هزینه اولیه
              </li>
              <li className="flex items-center gap-2">
                <span className="h-1.5 w-1.5 rounded-full bg-black" />
                آموزش سریع برای شما و همکاران
              </li>
              <li className="flex items-center gap-2">
                <span className="h-1.5 w-1.5 rounded-full bg-black" />
                پشتیبانی تلفنی و واتساپ
              </li>
              <li className="flex items-center gap-2">
                <span className="h-1.5 w-1.5 rounded-full bg-black" />
                امکان اتصال تأمین‌کنندگان مورداعتماد شما
              </li>
            </ul>
          </div>

          <div className="space-y-3 rounded-2xl border border-border bg-background p-4">
            <p className="text-xs text-muted-foreground">
              فرم زیر صرفاً نمونه طراحی است. در نسخه نهایی این بخش به فرم واقعی
              ثبت همکاری، اتصال پیدا می‌کند.
            </p>
            <form className="space-y-3 text-[11px]">
              <div className="space-y-1.5">
                <label className="block font-medium text-foreground">
                  نام مغازه / واحد صنفی
                </label>
                <input
                  disabled
                  placeholder="مثلاً: لوازم یدکی ولیعصر"
                  className="w-full rounded-xl border border-border bg-background px-3 py-2 text-[11px] text-foreground placeholder:text-muted-foreground/80"
                />
              </div>
              <div className="grid gap-3 sm:grid-cols-2">
                <div className="space-y-1.5">
                  <label className="block font-medium text-foreground">
                    نام و نام خانوادگی
                  </label>
                  <input
                    disabled
                    placeholder="نام مسئول فروشگاه"
                    className="w-full rounded-xl border border-border bg-background px-3 py-2 text-[11px] text-foreground placeholder:text-muted-foreground/80"
                  />
                </div>
                <div className="space-y-1.5">
                  <label className="block font-medium text-foreground">
                    شماره موبایل
                  </label>
                  <input
                    disabled
                    placeholder="۰۹xx xxx xxxx"
                    className="w-full rounded-xl border border-border bg-background px-3 py-2 text-[11px] text-foreground placeholder:text-muted-foreground/80"
                  />
                </div>
              </div>
              <div className="space-y-1.5">
                <label className="block font-medium text-foreground">
                  شهر فعالیت
                </label>
                <input
                  disabled
                  placeholder="مثلاً: تهران"
                  className="w-full rounded-xl border border-border bg-background px-3 py-2 text-[11px] text-foreground placeholder:text-muted-foreground/80"
                />
              </div>
              <button
                type="button"
                className="inline-flex w-full items-center justify-center rounded-xl bg-black px-4 py-2 text-xs font-semibold text-white transition hover:bg-neutral-800 disabled:cursor-not-allowed"
                disabled
              >
                ثبت درخواست دسترسی (به زودی)
              </button>
            </form>
          </div>
        </div>
      </div>
    </section>
  );
}

