type Feature = {
  title: string;
  description: string;
  tag: string;
};

const shopOwnerFeatures: Feature[] = [
  {
    title: "استعلام هم‌زمان از چندین تأمین‌کننده",
    description:
      "به‌جای تماس با چند نفر، یک‌بار استعلام می‌گیرید و تمام پیشنهادها را یک‌جا می‌بینید؛ با قیمت، برند و زمان تحویل.",
    tag: "ویژه مغازه‌دارها",
  },
  {
    title: "اولویت‌بندی هوشمند پیشنهادها",
    description:
      "الگوریتم کمبِر بهترین ترکیب قیمت، زمان تحویل و سابقه تأمین‌کننده را به‌عنوان پیشنهاد هوشمند به شما نشان می‌دهد.",
    tag: "پیشنهاد هوشمند",
  },
  {
    title: "ردیابی وضعیت سفارش تا تحویل",
    description:
      "از لحظه ثبت تا تحویل قطعه، وضعیت سفارش در پنل مشخص است؛ بدون پیگیری‌های تلفنی و ابهام.",
    tag: "شفافیت کامل",
  },
];

const supplierFeatures: Feature[] = [
  {
    title: "دسترسی به شبکه‌ای از مغازه‌دارها",
    description:
      "به‌عنوان تأمین‌کننده، بدون نیرو و بازاریاب اضافه، به ده‌ها مغازه‌دار فعال در سطح شهر متصل می‌شوید.",
    tag: "رشد فروش",
  },
  {
    title: "دریافت استعلام‌های دقیق و قابل پیگیری",
    description:
      "هر استعلام شفاف، با کد فنی و جزئیات کافی ثبت می‌شود تا بتوانید سریع و دقیق پیشنهاد بدهید.",
    tag: "کاهش خطا",
  },
  {
    title: "مدیریت قیمت و موجودی در یک پنل",
    description:
      "قیمت‌ها و شرایط تحویل‌تان را یک‌جا مدیریت می‌کنید و همیشه به‌روز در مقابل مغازه‌دارها دیده می‌شوید.",
    tag: "کنترل بهتر",
  },
];

export function FeaturesSection() {
  return (
    <section
      id="features"
      className="border-b border-border bg-background py-14 sm:py-16"
    >
      <div className="mx-auto max-w-6xl px-4 sm:px-6 lg:px-8">
        <div className="flex flex-col gap-6 lg:flex-row lg:items-start lg:justify-between">
          <div className="max-w-md space-y-3">
            <h2 className="text-xl font-semibold text-foreground sm:text-2xl">
              چرا کمبِر برای بازار قطعات یدکی ساخته شد؟
            </h2>
            <p className="text-sm text-muted-foreground">
              بازار قطعات یدکی پر از تماس‌های تلفنی، استعلام‌های تکراری و
              عدم‌اطمینان به موجودی لحظه‌ای است. کمبِر این مسیر را دیجیتال،
              شفاف و قابل پیش‌بینی می‌کند.
            </p>
          </div>

          <div className="grid flex-1 gap-4 lg:grid-cols-2">
            <FeatureCardGroup
              title="برای مغازه‌دارها"
              subtitle="سرعت بیشتر، حاشیه سود بهتر"
              items={shopOwnerFeatures}
            />
            <FeatureCardGroup
              title="برای تأمین‌کنندگان"
              subtitle="فروش متمرکز، بدون شلوغی"
              items={supplierFeatures}
            />
          </div>
        </div>
      </div>
    </section>
  );
}

type FeatureCardGroupProps = {
  title: string;
  subtitle: string;
  items: Feature[];
};

function FeatureCardGroup({ title, subtitle, items }: FeatureCardGroupProps) {
  return (
    <div className="flex flex-col rounded-2xl border border-border bg-white p-4 shadow-[0_14px_40px_rgba(15,23,42,0.08)]">
      <div className="mb-4 space-y-1">
        <h3 className="text-sm font-semibold text-foreground">{title}</h3>
        <p className="text-xs text-muted-foreground">{subtitle}</p>
      </div>
      <div className="space-y-3">
        {items.map((item) => (
          <article
            key={item.title}
            className="rounded-xl border border-border bg-background p-3"
          >
            <div className="mb-1.5 flex items-center justify-between gap-2">
              <h4 className="text-xs font-semibold text-foreground">
                {item.title}
              </h4>
              <span className="rounded-full bg-black/5 px-2 py-0.5 text-[9px] text-neutral-700">
                {item.tag}
              </span>
            </div>
            <p className="text-[11px] leading-relaxed text-muted-foreground">
              {item.description}
            </p>
          </article>
        ))}
      </div>
    </div>
  );
}

