import Image from "next/image";

export function HeroSection() {
  return (
    <section className="relative overflow-hidden border-b border-border bg-background">
      <div className="mx-auto flex max-w-6xl flex-col gap-10 px-4 pb-16 pt-10 sm:px-6 sm:pt-16 lg:flex-row lg:items-center lg:gap-16 lg:px-8 lg:pb-20">
        <div className="flex-1 space-y-6">
          <div className="inline-flex items-center gap-2 rounded-full border border-border bg-muted px-3 py-1 text-[11px] font-medium text-foreground/80 shadow-sm">
            <span className="h-1.5 w-1.5 rounded-full bg-black" />
            استارتاپ تأمین قطعات یدکی برای مغازه‌دارها
          </div>

          <div className="space-y-4">
            <h1 className="text-balance text-3xl font-semibold leading-tight text-foreground sm:text-4xl lg:text-5xl">
              استعلام قیمت قطعات یدکی
              <br />
              <span className="text-neutral-500">
                از چندین تأمین‌کننده در چند ثانیه
              </span>
            </h1>
            <p className="max-w-xl text-pretty text-sm leading-relaxed text-muted-foreground sm:text-base">
              کمبِر واسطی هوشمند بین مغازه‌دار و تأمین‌کننده است. کد یا توضیح
              قطعه را وارد می‌کنید، پیشنهاد قیمت و موجودی از چندین تأمین‌کننده
              دریافت می‌کنید و روی بهترین گزینه، مستقیم سفارش می‌گذارید.
            </p>
          </div>

          <div className="mt-4 space-y-3 text-xs">
            <div className="flex flex-col gap-3 sm:flex-row">
              <a
                href="#cta"
                className="inline-flex flex-1 items-center justify-center gap-2 rounded-full bg-black px-5 py-2.5 text-sm font-semibold text-white shadow-sm shadow-black/25 transition hover:bg-neutral-800 sm:flex-none"
              >
                شروع همکاری با کمبِر
              </a>
              <a
                href="#how-it-works"
                className="inline-flex flex-1 items-center justify-center rounded-full border border-border bg-background px-4 py-2.5 text-xs font-medium text-foreground transition hover:border-foreground/70 sm:flex-none"
              >
                مشاهده نحوه کار
              </a>
            </div>
          </div>
        </div>

        <div className="flex flex-1 items-center justify-center">
          <div className="relative w-full max-w-md">
            <div className="relative overflow-hidden rounded-3xl border border-border bg-white p-4 shadow-[0_18px_60px_rgba(15,23,42,0.12)]">
              <div className="flex items-center justify-between rounded-2xl border border-border bg-muted px-3 py-2 text-[11px] text-muted-foreground">
                <span className="inline-flex items-center gap-1.5">
                  <span className="h-1.5 w-1.5 rounded-full bg-black" />
                  استعلام جدید
                </span>
                <span className="rounded-full bg-background px-2 py-1 text-[10px] text-muted-foreground">
                  فروشگاه لوازم یدکی ولیعصر
                </span>
              </div>

              <div className="mt-3 space-y-3 rounded-2xl border border-border bg-background p-3 text-[11px] text-foreground">
                <div className="space-y-1.5">
                  <div className="flex items-center justify-between gap-2">
                    <span className="text-xs font-medium text-foreground">
                      دیسک ترمز جلو پژو ۲۰۶
                    </span>
                    <span className="rounded-full bg-black/5 px-2 py-0.5 text-[10px] text-neutral-700">
                      ۵ تأمین‌کننده
                    </span>
                  </div>
                  <p className="text-[10px] text-muted-foreground">
                    کد فنی: 96425173 | برند پیشنهادی: ایساکو / والئو
                  </p>
                </div>

                <div className="space-y-2">
                  <SupplierRow
                    name="انبار مرکزی تهران"
                    price="۲٬۳۵۰٬۰۰۰"
                    badge="پیشنهاد هوشمند کمبِر"
                    eta="تحویل امروز بعدازظهر"
                    best
                  />
                  <SupplierRow
                    name="تأمین‌کننده بازار چراغ‌برق"
                    price="۲٬۲۹۰٬۰۰۰"
                    eta="تحویل فردا صبح"
                  />
                  <SupplierRow
                    name="انبار کرج"
                    price="۲٬۴۰۰٬۰۰۰"
                    eta="تحویل ۲۴ تا ۴۸ ساعت"
                  />
                </div>

                <button className="mt-1 inline-flex w-full items-center justify-center gap-2 rounded-xl bg-black px-3 py-2 text-xs font-semibold text-white transition hover:bg-neutral-800">
                  ثبت سفارش روی پیشنهاد منتخب
                </button>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

type SupplierRowProps = {
  name: string;
  price: string;
  eta: string;
  badge?: string;
  best?: boolean;
};

function SupplierRow({ name, price, eta, badge, best }: SupplierRowProps) {
  return (
    <div
      className={`flex items-center justify-between gap-3 rounded-xl border px-3 py-2 ${
        best ? "border-black bg-black/3" : "border-border bg-muted"
      }`}
    >
      <div className="space-y-0.5">
        <div className="flex items-center gap-2">
          <span className="text-[11px] font-medium text-foreground">
            {name}
          </span>
          {badge ? (
            <span className="rounded-full bg-black/5 px-2 py-0.5 text-[9px] text-neutral-700">
              {badge}
            </span>
          ) : null}
        </div>
        <p className="text-[10px] text-muted-foreground">{eta}</p>
      </div>
      <div className="text-right">
        <div className="text-xs font-semibold text-foreground">
          {price} تومان
        </div>
        <div className="text-[9px] text-muted-foreground">۱ عدد</div>
      </div>
    </div>
  );
}
